/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterBlockWithBeginNode;

public class FormatterPHPElseNode
extends FormatterBlockWithBeginNode {
    private boolean hasBlock;
    private final boolean isElseIf;
    private final boolean previousIfHasBlock;
    private final boolean hasCommentBefore;

    public FormatterPHPElseNode(IFormatterDocument document, boolean hasBlock, boolean isElseIf, boolean previousIfHasBlock, boolean hasCommentBefore) {
        super(document);
        this.hasBlock = hasBlock;
        this.isElseIf = isElseIf;
        this.previousIfHasBlock = previousIfHasBlock;
        this.hasCommentBefore = hasCommentBefore;
    }

    public int getSpacesCountBefore() {
        return 1;
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return !this.isAddingBeginNewLine();
    }

    protected boolean isAddingBeginNewLine() {
        return this.hasCommentBefore || !this.previousIfHasBlock || this.getDocument().getBoolean("php.formatter.newline.before.else");
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        if (this.getBegin() != null) {
            boolean wroteIndent = false;
            if (this.getSpacesCountBefore() > 0 && this.shouldConsumePreviousWhiteSpaces()) {
                this.writeSpaces(visitor, context, this.getSpacesCountBefore());
            }
            if (this.isAddingBeginNewLine()) {
                if (!visitor.endsWithNewLine()) {
                    visitor.writeLineBreak(context);
                }
                if (this.isElseIf || !this.previousIfHasBlock) {
                    visitor.writeIndent(context);
                    wroteIndent = true;
                }
            } else if (visitor.endsWithNewLine()) {
                visitor.writeIndent(context);
                wroteIndent = true;
            }
            int indent = context.getIndent();
            if (wroteIndent) {
                context.resetIndent();
            }
            visitor.write(context, this.getBegin().getStartOffset(), this.getBegin().getEndOffset());
            if (wroteIndent) {
                context.setIndent(indent);
            }
        }
        if (!this.hasBlock && !this.isElseIf) {
            context.incIndent();
        }
        this.acceptBody(context, visitor);
        if (!this.hasBlock && !this.isElseIf) {
            context.decIndent();
        }
    }

    protected boolean isIndenting() {
        return !this.hasBlock && (!this.isElseIf || !this.getDocument().getBoolean("php.formatter.newline.before.if.in.elseif"));
    }
}

